$(document).ready(function () {
    if ($('#companyTable').length) {
        $('#companyTable').DataTable({
            responsive: false,
            dom: '<"dt-top"Bf>rt<"dt-bottom"ilp>',
            pageLength: 25,
            lengthMenu: [[10, 25, 100, 500, -1], [10, 25, 100, 500, "All"]],
            buttons: [
                {
                    extend: 'excelHtml5',
                    text: '<i class="fa-solid fa-file-excel"></i> Excel',
                    className: 'dt-button',
                    titleAttr: 'Export to Excel'
                },
                {
                    extend: 'pdfHtml5',
                    text: '<i class="fa-solid fa-file-pdf"></i> PDF',
                    className: 'dt-button',
                    titleAttr: 'Export to PDF'
                },
                {
                    extend: 'print',
                    text: '<i class="fa-solid fa-print"></i> Print',
                    className: 'dt-button',
                    titleAttr: 'Print Table'
                }
            ],
            language: {
                search: "",
                searchPlaceholder: "Quick search...",
                lengthMenu: "Show _MENU_",
                info: "Showing _START_ to _END_ of <b>_TOTAL_</b> entries",
                infoEmpty: "No entries found",
                infoFiltered: "(filtered from _MAX_ total)",
                paginate: {
                    first: '<i class="fa-solid fa-angles-left"></i>',
                    last: '<i class="fa-solid fa-angles-right"></i>',
                    next: '<i class="fa-solid fa-angle-right"></i>',
                    previous: '<i class="fa-solid fa-angle-left"></i>'
                }
            },
            drawCallback: function () {
                // Minor polish after each table draw
                $('.dataTables_paginate > .paginate_button').addClass('stat-card').css('padding', '0'); // Reset padding to let CSS handle it
            }
        });

        // Add search icon with better positioning
        if ($('.dt-search-icon').length === 0) {
            $('.dataTables_filter label').prepend('<i class="fa-solid fa-magnifying-glass dt-search-icon" style="position: absolute; left: 1.8rem; top: 50%; transform: translateY(-50%); color: var(--text-secondary); pointer-events: none; font-size: 0.85rem;"></i>');
            $('.dataTables_filter').css('position', 'relative');
        }
    }
});
