$(document).ready(function () {
    // Initialize Single Select2
    $('.select2-single').select2({
        placeholder: "Select an option",
        allowClear: true,
        width: '100%'
    });

    // Initialize Multi Select2
    $('.select2-multi').select2({
        placeholder: "Select multiple options",
        allowClear: true,
        width: '100%',
        closeOnSelect: false
    });

    // Auto-focus search field on Select2 open
    $(document).on('select2:open', () => {
        const searchField = document.querySelector('.select2-container--open .select2-search__field');
        if (searchField) {
            searchField.focus();
        }
    });

    // Handle Form Submission (Dummy)
    $('#addCompanyForm').on('submit', function (e) {
        e.preventDefault();

        const btn = $(this).find('button[type="submit"]');
        const originalText = btn.html();

        // Visual feedback
        btn.prop('disabled', true).html('<i class="fa-solid fa-circle-notch fa-spin"></i> Registering...');

        setTimeout(() => {
            alert('Company registered successfully! (This is a dummy action)');
            btn.prop('disabled', false).html(originalText);
        }, 1500);
    });
});
