<?php 
$page_title = "Central Hub | Companies";
include("../master/header.php"); 
?>

            <div class="heading-card">
                <h1>Central Hub</h1>
                <p>Track your business performance and manage your directory in real-time.</p>
            </div>

            <!-- Alert Notifications -->
            <div class="alert-container">
                <div class="hub-alert hub-alert-danger">
                    <i class="fa-solid fa-circle-exclamation"></i>
                    <span><strong>Urgent:</strong> 3 payments are overdue by more than 48 hours. Please review immediately.</span>
                </div>
                <div class="hub-alert hub-alert-warning">
                    <i class="fa-solid fa-triangle-exclamation"></i>
                    <span><strong>Update:</strong> 5 new bookings require confirmation from your side.</span>
                </div>
                <div class="hub-alert hub-alert-info">
                    <i class="fa-solid fa-circle-info"></i>
                    <span><strong>Notice:</strong> System maintenance scheduled for tonight at 2:00 AM SAR.</span>
                </div>
            </div>

            <!-- Stats Grid -->
            <div class="hub-stats-grid">
                <div class="stat-card card-rose">
                    <div class="stat-card-icon"><i class="fa-solid fa-wallet"></i></div>
                    <p style="color: var(--text-secondary); font-size: 0.8rem;">Total Payable</p>
                    <h3 style="font-size: 1.5rem; margin: 0.25rem 0;">SAR 45,210</h3>
                    <div style="color: #10b981; font-size: 0.75rem;"><i class="fa-solid fa-arrow-up"></i> 12% increase</div>
                </div>
                <!-- ... other cards ... -->
                <div class="stat-card card-emerald">
                    <div class="stat-card-icon"><i class="fa-solid fa-file-invoice-dollar"></i></div>
                    <p style="color: var(--text-secondary); font-size: 0.8rem;">Total Booking Price</p>
                    <h3 style="font-size: 1.5rem; margin: 0.25rem 0;">SAR 32,850</h3>
                    <div style="color: #10b981; font-size: 0.75rem;"><i class="fa-solid fa-arrow-up"></i> 8% increase</div>
                </div>
                <div class="stat-card card-blue">
                    <div class="stat-card-icon"><i class="fa-solid fa-bell-concierge"></i></div>
                    <p style="color: var(--text-secondary); font-size: 0.8rem;">Total Service Price</p>
                    <h3 style="font-size: 1.5rem; margin: 0.25rem 0;">SAR 12,360</h3>
                    <div style="color: #10b981; font-size: 0.75rem;"><i class="fa-solid fa-arrow-up"></i> 5% increase</div>
                </div>
                <div class="stat-card card-amber">
                    <div class="stat-card-icon"><i class="fa-solid fa-tags"></i></div>
                    <p style="color: var(--text-secondary); font-size: 0.8rem;">Total Discount</p>
                    <h3 style="font-size: 1.5rem; margin: 0.25rem 0;">SAR 2,450</h3>
                    <div style="color: #ef4444; font-size: 0.75rem;"><i class="fa-solid fa-arrow-down"></i> 2% decrease</div>
                </div>
                <div class="stat-card card-emerald">
                    <div class="stat-card-icon"><i class="fa-solid fa-credit-card"></i></div>
                    <p style="color: var(--text-secondary); font-size: 0.8rem;">Total Payments</p>
                    <h3 style="font-size: 1.5rem; margin: 0.25rem 0;">SAR 28,900</h3>
                    <div style="color: #10b981; font-size: 0.75rem;"><i class="fa-solid fa-chart-line"></i> Healthy trend</div>
                </div>
            </div>

            <!-- Action Hub Section -->
            <div class="action-hub-grid">
                <div class="action-card action-blue">
                    <div class="action-card-icon"><i class="fa-solid fa-gauge-high"></i></div>
                    <h4>Dashboard</h4>
                    <div class="action-btn-group">
                        <a href="index.php" class="action-btn action-btn-primary">
                            <i class="fa-solid fa-eye"></i> Visit
                        </a>
                    </div>
                </div>

                <div class="action-card action-indigo">
                    <div class="action-card-icon"><i class="fa-solid fa-calendar-check"></i></div>
                    <h4>Bookings</h4>
                    <div class="action-btn-group">
                        <a href="#" class="action-btn action-btn-outline">List</a>
                        <a href="#" class="action-btn action-btn-primary">Add</a>
                    </div>
                </div>

                <div class="action-card action-teal">
                    <div class="action-card-icon"><i class="fa-solid fa-users"></i></div>
                    <h4>Customers</h4>
                    <div class="action-btn-group">
                        <a href="#" class="action-btn action-btn-outline">List</a>
                        <a href="#" class="action-btn action-btn-primary">Add</a>
                    </div>
                </div>

                <div class="action-card action-orange">
                    <div class="action-card-icon"><i class="fa-solid fa-hand-holding-heart"></i></div>
                    <h4>Services</h4>
                    <div class="action-btn-group">
                        <a href="#" class="action-btn action-btn-outline">List</a>
                        <a href="#" class="action-btn action-btn-primary">Add</a>
                    </div>
                </div>

                <div class="action-card action-purple">
                    <div class="action-card-icon"><i class="fa-solid fa-money-bill-transfer"></i></div>
                    <h4>Payments</h4>
                    <div class="action-btn-group">
                        <a href="#" class="action-btn action-btn-primary">
                            <i class="fa-solid fa-arrow-right"></i> Visit
                        </a>
                    </div>
                </div>

                <div class="action-card action-pink">
                    <div class="action-card-icon"><i class="fa-solid fa-file-invoice"></i></div>
                    <h4>Invoices</h4>
                    <div class="action-btn-group">
                        <a href="#" class="action-btn action-btn-primary">
                            <i class="fa-solid fa-arrow-right"></i> Visit
                        </a>
                    </div>
                </div>

                <div class="action-card action-cyan">
                    <div class="action-card-icon"><i class="fa-solid fa-book-open"></i></div>
                    <h4>Ledgers</h4>
                    <div class="action-btn-group">
                        <a href="#" class="action-btn action-btn-primary">
                            <i class="fa-solid fa-arrow-right"></i> Visit
                        </a>
                    </div>
                </div>

                <div class="action-card action-emerald">
                    <div class="action-card-icon"><i class="fa-solid fa-user-circle"></i></div>
                    <h4>Profile</h4>
                    <div class="action-btn-group">
                        <a href="profile.php" class="action-btn action-btn-primary">
                            <i class="fa-solid fa-eye"></i> View
                        </a>
                    </div>
                </div>
            </div>

            <!-- Status Highlights (Bottom) -->
            <div class="status-stats-grid">
                <div class="status-card">
                    <div class="status-icon-circle status-pending"><i class="fa-solid fa-hourglass-half"></i></div>
                    <div class="status-info">
                        <span class="status-label">Total Pending</span>
                        <span class="status-count">12</span>
                    </div>
                </div>
                <div class="status-card">
                    <div class="status-icon-circle status-confirmed"><i class="fa-solid fa-circle-check"></i></div>
                    <div class="status-info">
                        <span class="status-label">Total Confirmed</span>
                        <span class="status-count">48</span>
                    </div>
                </div>
                <div class="status-card">
                    <div class="status-icon-circle status-completed"><i class="fa-solid fa-flag-checkered"></i></div>
                    <div class="status-info">
                        <span class="status-label">Total Completed</span>
                        <span class="status-count">256</span>
                    </div>
                </div>
                <div class="status-card">
                    <div class="status-icon-circle status-cancelled"><i class="fa-solid fa-ban"></i></div>
                    <div class="status-info">
                        <span class="status-label">Total Cancelled</span>
                        <span class="status-count">4</span>
                    </div>
                </div>
            </div>

            <!-- Recent Payments -->
            <div class="stat-card" style="padding: 1.25rem; border-radius: 15px; margin-top: 3rem;">
                <h2 style="margin-bottom: 1rem; font-size: 1.25rem;">Recent Payments</h2>
                <div style="overflow-x: auto;">
                    <table style="width: 100%; border-collapse: collapse;">
                        <thead>
                            <tr style="text-align: left; border-bottom: 1px solid var(--glass-border);">
                                <th style="padding: 0.75rem; color: var(--text-secondary);">GPID</th>
                                <th style="padding: 0.75rem; color: var(--text-secondary);">Date</th>
                                <th style="padding: 0.75rem; color: var(--text-secondary);">Amount</th>
                                <th style="padding: 0.75rem; color: var(--text-secondary);">Method</th>
                                <th style="padding: 0.75rem; color: var(--text-secondary);">Status</th>
                                <th style="padding: 0.75rem; color: var(--text-secondary);">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr style="border-bottom: 1px solid var(--glass-border);">
                                <td style="padding: 0.75rem; font-weight: 500;">GP-901</td>
                                <td style="padding: 0.75rem;">Jan 4, 2026</td>
                                <td style="padding: 0.75rem;">SAR 1,250</td>
                                <td style="padding: 0.75rem;"><i class="fa-solid fa-credit-card"></i> Visa</td>
                                <td style="padding: 0.75rem;"><span style="background: rgba(16, 185, 129, 0.1); color: #10b981; padding: 0.2rem 0.6rem; border-radius: 20px; font-size: 0.7rem;">Completed</span></td>
                                <td style="padding: 0.75rem;"><button class="btn-gradient" style="padding: 0.4rem 0.8rem; font-size: 0.7rem;">View Receipt</button></td>
                            </tr>
                            <tr style="border-bottom: 1px solid var(--glass-border);">
                                <td style="padding: 0.75rem; font-weight: 500;">GP-902</td>
                                <td style="padding: 0.75rem;">Jan 4, 2026</td>
                                <td style="padding: 0.75rem;">SAR 450</td>
                                <td style="padding: 0.75rem;"><i class="fa-solid fa-money-bill-1-wave"></i> Cash</td>
                                <td style="padding: 0.75rem;"><span style="background: rgba(16, 185, 129, 0.1); color: #10b981; padding: 0.2rem 0.6rem; border-radius: 20px; font-size: 0.7rem;">Completed</span></td>
                                <td style="padding: 0.75rem;"><button class="btn-gradient" style="padding: 0.4rem 0.8rem; font-size: 0.7rem;">View Receipt</button></td>
                            </tr>
                            <tr style="border-bottom: 1px solid var(--glass-border);">
                                <td style="padding: 0.75rem; font-weight: 500;">GP-903</td>
                                <td style="padding: 0.75rem;">Jan 3, 2026</td>
                                <td style="padding: 0.75rem;">SAR 2,100</td>
                                <td style="padding: 0.75rem;"><i class="fa-solid fa-building-columns"></i> Bank Transfer</td>
                                <td style="padding: 0.75rem;"><span style="background: rgba(245, 158, 11, 0.1); color: #f59e0b; padding: 0.2rem 0.6rem; border-radius: 20px; font-size: 0.7rem;">Pending</span></td>
                                <td style="padding: 0.75rem;"><button class="btn-gradient" style="padding: 0.4rem 0.8rem; font-size: 0.7rem;">View Receipt</button></td>
                            </tr>
                            <tr style="border-bottom: 1px solid var(--glass-border);">
                                <td style="padding: 0.75rem; font-weight: 500;">GP-904</td>
                                <td style="padding: 0.75rem;">Jan 3, 2026</td>
                                <td style="padding: 0.75rem;">SAR 850</td>
                                <td style="padding: 0.75rem;"><i class="fa-solid fa-credit-card"></i> Visa</td>
                                <td style="padding: 0.75rem;"><span style="background: rgba(16, 185, 129, 0.1); color: #10b981; padding: 0.2rem 0.6rem; border-radius: 20px; font-size: 0.7rem;">Completed</span></td>
                                <td style="padding: 0.75rem;"><button class="btn-gradient" style="padding: 0.4rem 0.8rem; font-size: 0.7rem;">View Receipt</button></td>
                            </tr>
                            <tr style="border-bottom: 1px solid var(--glass-border);">
                                <td style="padding: 0.75rem; font-weight: 500;">GP-912</td>
                                <td style="padding: 0.75rem;">Jan 2, 2026</td>
                                <td style="padding: 0.75rem;">SAR 120</td>
                                <td style="padding: 0.75rem;"><i class="fa-solid fa-money-bill-1-wave"></i> Cash</td>
                                <td style="padding: 0.75rem;"><span style="background: rgba(239, 68, 68, 0.1); color: #ef4444; padding: 0.2rem 0.6rem; border-radius: 20px; font-size: 0.7rem;">Cancelled</span></td>
                                <td style="padding: 0.75rem;"><button class="btn-gradient" style="padding: 0.4rem 0.8rem; font-size: 0.7rem;">View Receipt</button></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

<?php include("../master/footer.php"); ?>
