<?php 
$page_title = "Register New Company";

// Include Select2 CSS
$extra_css = '
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
    /* Inline adjustment for Select2 alignment with icons */
    .select2-container { width: 100% !important; }
</style>';

// Include Select2 and Init JS
$extra_js = '
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="../master/js/form-init.js"></script>';

include("../master/header.php"); 
?>

    <div class="heading-card">
        <div class="heading-card-header">
            <div>
                <h1>Register Company</h1>
                <p>Complete the profile below to add a new organization to the network.</p>
            </div>
            <a href="list.php" class="add-btn" style="background: rgba(255,255,255,0.1); border: 1px solid var(--glass-border); color: white !important;">
                <i class="fa-solid fa-arrow-left"></i>
                Back to List
            </a>
        </div>
    </div>

    <div class="form-container">
        <form action="#" method="POST" id="addCompanyForm">
            <div class="form-grid">
                <!-- Basic Info -->
                <div class="form-group full-width">
                    <label class="form-label">Company Name</label>
                    <div class="input-icon-wrapper">
                        <i class="fa-solid fa-building"></i>
                        <input type="text" class="form-control-premium" placeholder="e.g. Tech Nova Solutions" required>
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Email Address</label>
                    <div class="input-icon-wrapper">
                        <i class="fa-solid fa-envelope"></i>
                        <input type="email" class="form-control-premium" placeholder="contact@company.com">
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Website</label>
                    <div class="input-icon-wrapper">
                        <i class="fa-solid fa-globe"></i>
                        <input type="url" class="form-control-premium" placeholder="https://www.company.com">
                    </div>
                </div>

                <!-- Select Sections -->
                <div class="form-group">
                    <label class="form-label">Simple Select (Native)</label>
                    <select class="form-control-premium">
                        <option value="">Choose an option...</option>
                        <option value="1">Option One</option>
                        <option value="2">Option Two</option>
                        <option value="3">Option Three</option>
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label">Searchable Select (Select2)</label>
                    <select class="select2-single form-control-premium">
                        <option value="">Search Industry...</option>
                        <option value="tech">Technology</option>
                        <option value="finance">Finance</option>
                        <option value="healthcare">Healthcare</option>
                        <option value="education">Education</option>
                        <option value="retail">Retail</option>
                    </select>
                </div>

                <div class="form-group full-width">
                    <label class="form-label">Multi-Select Services (Select2)</label>
                    <select class="select2-multi form-control-premium" multiple="multiple">
                        <option value="web" selected>Web Development</option>
                        <option value="mobile">Mobile Apps</option>
                        <option value="cloud">Cloud Solutions</option>
                        <option value="seo">SEO Optimization</option>
                        <option value="design">UI/UX Design</option>
                    </select>
                </div>

                <!-- Details -->
                <div class="form-group full-width">
                    <label class="form-label">Company Description</label>
                    <textarea class="form-control-premium" rows="4" placeholder="Briefly describe the company's core business..."></textarea>
                </div>

                <div class="form-group">
                    <label class="form-label">Location</label>
                    <div class="input-icon-wrapper">
                        <i class="fa-solid fa-location-dot"></i>
                        <input type="text" class="form-control-premium" placeholder="City, Country">
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Status</label>
                    <label class="form-switch">
                        <input type="checkbox" checked>
                        <span class="switch-slider"></span>
                        <span style="font-size: 0.85rem; color: var(--text-secondary);">Active Member</span>
                    </label>
                </div>

                <div class="form-group full-width" style="margin-top: 1rem;">
                    <button type="submit" class="add-btn" style="width: 100%; justify-content: center; font-size: 1rem; padding: 1rem;">
                        <i class="fa-solid fa-plus"></i>
                        Register New Company
                    </button>
                </div>
            </div>
        </form>
    </div>

<?php include("../master/footer.php"); ?>
